<?php

namespace MbeGroup\HomeLayout\Filament;

use Filament\Contracts\Plugin;
use Filament\Panel;
use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;

class HomeLayoutPlugin implements Plugin
{
    public function getId(): string { return 'home_layout'; }
    public function register(Panel $panel): void
    {
        $panel->resources([
            HomeLayoutResource::class,
        ]);
    }

    public function boot(Panel $panel): void
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                NavigationGroup::make()
                    ->label(__('home-layout::filament.resources.home_layout.navigation_group'))
                    ->icon('heroicon-s-home'),
            ]);
        });
    }
}
