<?php

namespace MbeGroup\HomeLayout\Filament\Resources;

use MbeGroup\HomeLayout\Models\HomeLayout;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Pages\ListHomeLayouts;
use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Pages\CreateHomeLayout;
use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Pages\EditHomeLayout;
use BackedEnum;
use Filament\Actions;

class HomeLayoutResource extends Resource
{
    protected static ?string $model = HomeLayout::class;

    protected static string|BackedEnum|null $navigationIcon = null;

    public static function getNavigationGroup(): string
    {
        return __('home-layout::filament.resources.home_layout.navigation_group');
    }

    public static function getNavigationLabel(): string
    {
        return __('home-layout::filament.resources.home_layout.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('home-layout::filament.resources.home_layout.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('home-layout::filament.resources.home_layout.plural_model_label');
    }

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->schema([]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('home-layout::filament.resources.home_layout.table.columns.name'))
                    ->searchable(),
                Tables\Columns\TextColumn::make('slug')
                    ->label(__('home-layout::filament.resources.home_layout.table.columns.slug'))
                    ->searchable(),
                Tables\Columns\IconColumn::make('enabled')
                    ->label(__('home-layout::filament.resources.home_layout.table.columns.enabled'))
                    ->boolean(),
                Tables\Columns\TextColumn::make('created_at')
                ->label(__('home-layout::filament.resources.home_layout.table.columns.created_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                ->label(__('home-layout::filament.resources.home_layout.table.columns.updated_at'))
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\TernaryFilter::make('enabled'),
            ])
            ->actions([
                Actions\EditAction::make(),
            ])
            ->bulkActions([
                Actions\BulkActionGroup::make([
                    Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->description('Version: ' . \Composer\InstalledVersions::getVersion('mbegroup/home-layout'));
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListHomeLayouts::route('/'),
            'create' => CreateHomeLayout::route('/create'),
            'edit' => EditHomeLayout::route('/{record}/edit'),
        ];
    }
}
