<?php

namespace MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Pages;

use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Forms;
use Filament\Schemas\Schema;

class CreateHomeLayout extends CreateRecord
{
    protected static string $resource = HomeLayoutResource::class;

    public function form(Schema $schema): Schema
    {
        return $schema->schema([
            Forms\Components\TextInput::make('name')->label(__('home-layout::filament.resources.home_layout.form.fields.name'))->required(),
            Forms\Components\TextInput::make('slug')->label(__('home-layout::filament.resources.home_layout.form.fields.slug'))->required()->unique(HomeLayoutResource::getModel(), 'slug', ignoreRecord: true),
        ]);
    }
}
