<?php

namespace MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource;
use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Forms\FormsInterface;
use Filament\Schemas\Schema;

class EditHomeLayout extends EditRecord
{
    protected static string $resource = HomeLayoutResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    public function form(Schema $schema): Schema
    {
        $class = 'MbeGroup\\HomeLayout\\Filament\\Resources\\HomeLayoutResource\\Forms\\' . str_replace(' ', '', ucwords(str_replace(['-', '_'], ' ', $this->record->slug)));

        if (!class_exists($class) || !in_array(FormsInterface::class, class_implements($class))) {
            throw new \Exception("Class $class does not exist or does not implement FormsInterface");
        }

        $schema = $class::formSchema($schema);

        return $schema;
    }
}
