<?php

namespace MbeGroup\HomeLayout\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use MbeGroup\Content\Resources\ContentResource;

class ArticlesHomeLayoutResource extends JsonResource
{
        /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'         => $this->id,
            'name'       => $this->name,
            'slug'       => $this->slug,
            'articles'   => ContentResource::collection($this->getArticles()),
        ];
    }
}
