<?php

namespace MbeGroup\HomeLayout\Services;

use MbeGroup\HomeLayout\Contracts\HomeLayoutServiceInterface;
use MbeGroup\HomeLayout\Models\HomeLayout;
use MbeGroup\HomeLayout\Resources\ArticlesHomeLayoutResource;
use MbeGroup\HomeLayout\Resources\HomeLayoutResource;

class HomeLayoutService implements HomeLayoutServiceInterface
{
    public function __construct(
    ) {}

    public function get(string $slug): HomeLayout
    {
        return HomeLayout::where('slug', $slug)->firstOrFail();
    }

    public function getResourceBySlug(string $slug): string
    {
        return match ($slug) {
            'articles' => ArticlesHomeLayoutResource::class,
            default    => HomeLayoutResource::class,
        };
    }
}
