<?php

namespace Tests\Unit;

use MbeGroup\HomeLayout\Contracts\HomeLayoutServiceInterface;
use MbeGroup\HomeLayout\Controllers\Api\V1\HomeLayoutController;
use PHPUnit\Framework\TestCase;
use Mockery;

class HomeLayoutControllerTest extends TestCase
{
    protected $serviceMock;
    protected HomeLayoutController $controller;

    protected function setUp(): void
    {
        parent::setUp();
        $this->serviceMock = Mockery::mock(HomeLayoutServiceInterface::class);
        $this->controller = new HomeLayoutController($this->serviceMock);
    }

    protected function tearDown(): void
    {
        Mockery::close();
        parent::tearDown();
    }

    public function test_controller_uses_injected_service(): void
    {
        $reflection = new \ReflectionClass($this->controller);
        $property = $reflection->getProperty('service');
        $property->setAccessible(true);

        $this->assertInstanceOf(
            HomeLayoutServiceInterface::class,
            $property->getValue($this->controller)
        );
    }

    public function test_controller_has_service_property(): void
    {
        $reflection = new \ReflectionClass($this->controller);
        $this->assertTrue($reflection->hasProperty('service'));
    }

    public function test_controller_has_resource_name_property(): void
    {
        $reflection = new \ReflectionClass($this->controller);
        $this->assertTrue($reflection->hasProperty('resourceName'));

        $property = $reflection->getProperty('resourceName');
        $property->setAccessible(true);
        $this->assertEquals('home_layout', $property->getValue($this->controller));
    }

    public function test_controller_has_index_method(): void
    {
        $this->assertTrue(method_exists($this->controller, 'index'));
    }

    public function test_controller_has_show_method(): void
    {
        $this->assertTrue(method_exists($this->controller, 'show'));
    }

    public function test_controller_has_store_method(): void
    {
        $this->assertTrue(method_exists($this->controller, 'store'));
    }

    public function test_controller_has_update_method(): void
    {
        $this->assertTrue(method_exists($this->controller, 'update'));
    }

    public function test_controller_has_destroy_method(): void
    {
        $this->assertTrue(method_exists($this->controller, 'destroy'));
    }

    public function test_show_method_is_public(): void
    {
        $reflection = new \ReflectionMethod($this->controller, 'show');
        $this->assertTrue($reflection->isPublic());
    }

    public function test_show_method_accepts_string_parameter(): void
    {
        $reflection = new \ReflectionMethod($this->controller, 'show');
        $parameters = $reflection->getParameters();

        $this->assertCount(1, $parameters);
        $this->assertEquals('slug', $parameters[0]->getName());
        $this->assertTrue($parameters[0]->hasType());
        $this->assertEquals('string', $parameters[0]->getType()->getName());
    }

    public function test_index_method_is_public(): void
    {
        $reflection = new \ReflectionMethod($this->controller, 'index');
        $this->assertTrue($reflection->isPublic());
    }

    public function test_store_method_is_public(): void
    {
        $reflection = new \ReflectionMethod($this->controller, 'store');
        $this->assertTrue($reflection->isPublic());
    }

    public function test_update_method_is_public(): void
    {
        $reflection = new \ReflectionMethod($this->controller, 'update');
        $this->assertTrue($reflection->isPublic());
    }

    public function test_destroy_method_is_public(): void
    {
        $reflection = new \ReflectionMethod($this->controller, 'destroy');
        $this->assertTrue($reflection->isPublic());
    }

    public function test_controller_extends_crud_api_controller(): void
    {
        $reflection = new \ReflectionClass($this->controller);
        $this->assertEquals(
            'App\Http\Controllers\Api\V1\CrudApiController',
            $reflection->getParentClass()->getName()
        );
    }

    public function test_controller_is_final(): void
    {
        $reflection = new \ReflectionClass($this->controller);
        $this->assertTrue($reflection->isFinal());
    }

    public function test_constructor_accepts_service_interface(): void
    {
        $reflection = new \ReflectionClass($this->controller);
        $constructor = $reflection->getConstructor();

        $this->assertNotNull($constructor);
        $parameters = $constructor->getParameters();

        $this->assertCount(1, $parameters);
        $this->assertEquals('service', $parameters[0]->getName());
    }

    public function test_service_property_is_protected(): void
    {
        $reflection = new \ReflectionClass($this->controller);
        $property = $reflection->getProperty('service');

        $this->assertTrue($property->isProtected());
    }
}
