<?php
namespace MbeGroup\HomeLayout\Models;

use MongoDB\Laravel\Eloquent\Model;
use MbeGroup\Content\Models\Content;
use App\ValueObject\Status;

class HomeLayout extends Model
{
    protected $connection = 'mongodb';
    protected $collection = 'home_layouts';
    protected $fillable   = ['slug', 'name', 'enabled', 'data'];
    protected $casts      = [
        'data' => 'array',
    ];

    public function getArticles()
    {
        $slugs = $this->data['article_slugs'] ?? [];

        if (empty($slugs)) {
            return collect([]);
        }

        $articles = Content::whereIn('slug', $slugs)
            ->where('status', Status::ACTIVE)
            ->get();

        return $articles->sortBy(function ($article) use ($slugs) {
            return array_search($article->slug, $slugs);
        })->values();
    }
}
