<?php
namespace MbeGroup\HomeLayout\Providers;

use Illuminate\Support\ServiceProvider;
use MbeGroup\HomeLayout\Contracts;
use MbeGroup\HomeLayout\Services;

final class HomeLayoutServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');
        $this->loadTranslationsFrom(__DIR__ . '/../../lang', 'home-layout');

        $this->app->bind(
            Contracts\HomeLayoutServiceInterface::class,
            Services\HomeLayoutService::class,
        );
    }
}
