<?php

namespace Tests\Unit;

use MbeGroup\HomeLayout\Models\HomeLayout;
use PHPUnit\Framework\TestCase;

class HomeLayoutTest extends TestCase
{
    public function test_home_layout_has_correct_connection(): void
    {
        $layout = new HomeLayout();

        $this->assertEquals('mongodb', $layout->getConnectionName());
    }

    public function test_home_layout_has_correct_collection_name(): void
    {
        $layout = new HomeLayout();

        $this->assertEquals('home_layouts', $layout->getTable());
    }

    public function test_home_layout_has_fillable_attributes(): void
    {
        $layout = new HomeLayout();

        $this->assertEquals(
            ['slug', 'name', 'enabled', 'data'],
            $layout->getFillable()
        );
    }

    public function test_home_layout_has_correct_casts(): void
    {
        $layout = new HomeLayout();

        $casts = $layout->getCasts();
        $this->assertArrayHasKey('data', $casts);
        $this->assertEquals('array', $casts['data']);
    }

    public function test_home_layout_casts_data_to_array(): void
    {
        $layout = new HomeLayout();
        $layout->data = ['key' => 'value'];

        $this->assertIsArray($layout->data);
        $this->assertEquals(['key' => 'value'], $layout->data);
    }

    public function test_get_articles_returns_empty_collection_when_no_data(): void
    {
        $layout = new HomeLayout();
        $layout->data = [];

        $articles = $layout->getArticles();

        $this->assertInstanceOf(\Illuminate\Support\Collection::class, $articles);
        $this->assertTrue($articles->isEmpty());
    }

    public function test_get_articles_returns_empty_collection_when_article_slugs_empty(): void
    {
        $layout = new HomeLayout();
        $layout->data = ['article_slugs' => []];

        $articles = $layout->getArticles();

        $this->assertInstanceOf(\Illuminate\Support\Collection::class, $articles);
        $this->assertTrue($articles->isEmpty());
    }

    public function test_get_articles_returns_empty_collection_when_article_slugs_not_set(): void
    {
        $layout = new HomeLayout();
        $layout->data = ['other_field' => 'value'];

        $articles = $layout->getArticles();

        $this->assertInstanceOf(\Illuminate\Support\Collection::class, $articles);
        $this->assertTrue($articles->isEmpty());
    }

    public function test_model_uses_mongodb_connection(): void
    {
        $layout = new HomeLayout();

        $reflection = new \ReflectionClass($layout);
        $property = $reflection->getProperty('connection');
        $property->setAccessible(true);

        $this->assertEquals('mongodb', $property->getValue($layout));
    }

    public function test_model_uses_home_layouts_collection(): void
    {
        $layout = new HomeLayout();

        $reflection = new \ReflectionClass($layout);
        $property = $reflection->getProperty('collection');
        $property->setAccessible(true);

        $this->assertEquals('home_layouts', $property->getValue($layout));
    }
}
