<?php

namespace MbeGroup\HomeLayout\Controllers\Api\V1;

use App\Http\Controllers\Api\V1\CrudApiController;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use MbeGroup\HomeLayout\Contracts\HomeLayoutServiceInterface;

final class HomeLayoutController extends CrudApiController
{
    protected string $resourceName = 'home_layout';

    public function __construct(
        protected HomeLayoutServiceInterface $service,
    ) {
    }

    public function index(Request $request): JsonResponse
    {
        return $this->notImplemented('index');
    }

    public function show(string $slug): JsonResponse
    {
        $layout       = $this->service->get($slug);
        $resourceName = $this->service->getResourceBySlug($slug);

        return $this->success(new $resourceName($layout));
    }

    public function store(Request $request): JsonResponse
    {
        return $this->notImplemented('store');
    }

    public function update(Request $request, string $id): JsonResponse
    {
        return $this->notImplemented('update');
    }

    public function destroy(string $id): JsonResponse
    {
        return $this->notImplemented('destroy');
    }
}
