<?php

namespace MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Forms;

use MbeGroup\HomeLayout\Filament\Resources\HomeLayoutResource\Forms\FormsInterface;
use Filament\Forms;
use Filament\Schemas\Schema;
use Filament\Schemas\Components\Group;
use App\ValueObject\Status;

class Articles implements FormsInterface
{
    public static function formSchema(Schema $schema): Schema
    {
        return $schema->schema([
            Forms\Components\TextInput::make('name')
                ->label(__('home-layout::filament.resources.home_layout.form.fields.name'))
                ->required(),
            Forms\Components\TextInput::make('slug')
                ->label(__('home-layout::filament.resources.home_layout.form.fields.slug'))
                ->required(),
            Forms\Components\Toggle::make('enabled')
                ->label(__('home-layout::filament.resources.home_layout.form.fields.enabled'))
                ->default(true),
            Group::make([
                Forms\Components\Select::make('article_slugs')
                    ->label(__('home-layout::filament.resources.home_layout.form.fields.articles'))
                    ->multiple()
                    ->searchable()
                    ->options(function () {
                        return \MbeGroup\Content\Models\Content::where('status', Status::ACTIVE)
                            ->where('type', 'article')
                            ->orderBy('created_at', 'desc')
                            ->pluck('title', 'slug')
                            ->mapWithKeys(fn($title, $slug) => ["$slug" => $title])
                            ->toArray();
                    })
                    ->preload()
                    ->required()
                    ->afterStateHydrated(function ($component, $state) {
                        if (is_array($state)) {
                            $component->state(array_map('strval', $state));
                        }
                    })
                    ->dehydrateStateUsing(fn ($state) => is_array($state) ? array_map('strval', $state) : $state),
            ])->statePath('data'),
        ]);
    }
}
