<?php
use Illuminate\Support\Facades\Route;
use Modules\Homepage\Models\Homepage;

Route::prefix('api/v1')->group(function () {
    // GET /api/v1/homepage/home
    Route::get('/homepage/{slug}', function (string $slug) {
        $doc = Homepage::where('slug', $slug)->first();
        if (!$doc || !$doc->published) {
            return response()->json(['message' => 'Not found'], 404);
        }

        return response()->json([
            'slug'      => $doc->slug,
            'title'     => $doc->title,
        ]);
    });

    // (opcjonalnie) PUT /api/v1/homepage/home — prosta aktualizacja
    Route::put('/homepage/{slug}', function (string $slug) {
        request()->validate([
            'title'     => 'required|string|max:120',
            'blocks'    => 'array',
            'seo'       => 'array',
            'published' => 'boolean',
        ]);
        $doc = Homepage::updateOrCreate(
            ['slug' => $slug],
            [
                'title'     => request('title'),
                'blocks'    => request('blocks', []),
                'seo'       => request('seo', []),
                'published' => (bool) request('published', true),
            ]
        );
        return response()->json($doc->toArray());
    });
});
