<?php

namespace YourOrg\Homepage\Filament\Resources\HomepageResource\Forms;

use YourOrg\Homepage\Filament\Resources\HomepageResource\Forms\FormsInterface;
use Filament\Forms\Form;
use Filament\Forms;

class PromotionLink implements FormsInterface
{
    public static function formSchema(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('name')->label('Nazwa')->required(),
            Forms\Components\TextInput::make('slug')->label('Slug')->required(),
            Forms\Components\Toggle::make('published')->label('Aktywny')->required()->default(true),
            Forms\Components\Group::make([
                Forms\Components\TextInput::make('url')->url()->required(),
                Forms\Components\TextInput::make('label')->required(),
            ])->statePath('data'),
        ]);
    }
}
