<?php
use MongoDB\Client;

return new class {
    public function up(Client $client): void {
        $dbName = env('MONGODB_DATABASE','app');
        $db = $client->selectDatabase($dbName);

        $collections = array_map(fn($c)=>$c->getName(), iterator_to_array($db->listCollections()));
        if (!in_array('homepages', $collections, true)) {
            $db->createCollection('homepages', [
                'validator' => ['$jsonSchema' => [
                    'bsonType' => 'object',
                    'required' => ['slug','title'],
                    'properties' => [
                        'slug'      => ['bsonType'=>'string','pattern'=>'^[a-z0-9-]+$','maxLength'=>120],
                        'title'     => ['bsonType'=>'string','maxLength'=>120],
                        'blocks'    => ['bsonType'=>'array'],
                        'seo'       => ['bsonType'=>'object'],
                        'published' => ['bsonType'=>'bool']
                    ]
                ]]
            ]);
        }

        $col = $db->selectCollection('homepages');
        $col->createIndex(['slug'=>1], ['unique'=>true]);
        $col->createIndex(['updated_at'=>-1]);
    }
};
