<?php

namespace YourOrg\Homepage\Filament\Resources\HomepageResource\Forms;

use YourOrg\Homepage\Filament\Resources\HomepageResource\Forms\FormsInterface;
use Filament\Forms\Form;
use Filament\Forms;

class PromotionLink implements FormsInterface
{
    public static function formSchema(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('name')
                ->label(__('homepage::filament.resources.homepage.form.fields.name'))
                ->required(),
            Forms\Components\TextInput::make('slug')
                ->label(__('homepage::filament.resources.homepage.form.fields.slug'))
                ->required(),
            Forms\Components\Toggle::make('enabled')
                ->label(__('homepage::filament.resources.homepage.form.fields.enabled'))
                ->default(true),
            Forms\Components\Group::make([
                Forms\Components\TextInput::make('url')
                    ->url()
                    ->label(__('homepage::filament.resources.homepage.form.fields.url'))
                    ->required(),
                Forms\Components\TextInput::make('label')
                    ->label(__('homepage::filament.resources.homepage.form.fields.label'))
                    ->required(),
            ])->statePath('data'),
        ]);
    }
}
