<?php

namespace YourOrg\Homepage\Filament\Resources\HomepageResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Forms\Form;
use YourOrg\Homepage\Filament\Resources\HomepageResource;
use YourOrg\Homepage\Filament\Resources\HomepageResource\Forms\FormsInterface;

class EditHomepage extends EditRecord
{
    protected static string $resource = HomepageResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    public function form(Form $form): Form
    {
        $class = 'YourOrg\\Homepage\\Filament\\Resources\\HomepageResource\\Forms\\' . str_replace(' ', '', ucwords(str_replace(['-', '_'], ' ', $this->record->slug)));

        if (!class_exists($class) || !in_array(FormsInterface::class, class_implements($class))) {
            throw new \Exception("Class $class does not exist or does not implement FormsInterface");
        }

        $schema = $class::formSchema($form);

        return $schema;
    }
}
