<?php

namespace MbeGroup\Homepage\Filament\Resources\HomepageResource\Forms;

use MbeGroup\Homepage\Filament\Resources\HomepageResource\Forms\FormsInterface;
use Filament\Forms\Form;
use Filament\Forms;

class Home implements FormsInterface
{
    public static function formSchema(Form $form): Form
    {
        return $form->schema([
            Forms\Components\TextInput::make('name')
                ->label(__('homepage::filament.resources.homepage.form.fields.name'))
                ->required(),
            Forms\Components\TextInput::make('slug')
                ->label(__('homepage::filament.resources.homepage.form.fields.slug'))
                ->required(),
            Forms\Components\Toggle::make('enabled')
                ->label(__('homepage::filament.resources.homepage.form.fields.enabled'))
                ->default(true),
            Forms\Components\Group::make([
                Forms\Components\TextInput::make('color')
                    ->label(__('homepage::filament.resources.homepage.form.fields.color'))
                    ->required(),
                Forms\Components\TextInput::make('backgroud_color')
                    ->label(__('homepage::filament.resources.homepage.form.fields.backgroud_color'))
                    ->required(),
            ])->statePath('data'),
        ]);
    }
}
