<?php
use Illuminate\Support\Facades\Route;
use Modules\Homepage\Models\Homepage;

Route::prefix('api/v1')->group(function () {
    Route::get('/homepage/{slug}', function (string $slug) {
        $doc = Homepage::where('slug', $slug)->first();
        if (!$doc || !$doc->published) {
            return response()->json(['message' => 'Not found'], 404);
        }

        return response()->json([
            'slug'      => $doc->slug,
            'title'     => $doc->title,
        ]);
    });
});
