<?php

namespace MbeGroup\Homepage\Filament\Resources\HomepageResource\Pages;

use MbeGroup\Homepage\Filament\Resources\HomepageResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Forms;
use Filament\Schemas\Schema;

class CreateHomepage extends CreateRecord
{
    protected static string $resource = HomepageResource::class;

    public function form(Schema $schema): Schema
    {
        return $schema->schema([
            Forms\Components\TextInput::make('name')->label(__('homepage::filament.resources.homepage.form.fields.name'))->required(),
            Forms\Components\TextInput::make('slug')->label(__('homepage::filament.resources.homepage.form.fields.slug'))->required()->unique(HomepageResource::getModel(), 'slug', ignoreRecord: true),
        ]);
    }
}
