<?php

namespace MbeGroup\Homepage\Filament\Resources\HomepageResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use MbeGroup\Homepage\Filament\Resources\HomepageResource;
use MbeGroup\Homepage\Filament\Resources\HomepageResource\Forms\FormsInterface;
use Filament\Schemas\Schema;

class EditHomepage extends EditRecord
{
    protected static string $resource = HomepageResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    public function form(Schema $schema): Schema
    {
        $class = 'MbeGroup\\Homepage\\Filament\\Resources\\HomepageResource\\Forms\\' . str_replace(' ', '', ucwords(str_replace(['-', '_'], ' ', $this->record->slug)));

        if (!class_exists($class) || !in_array(FormsInterface::class, class_implements($class))) {
            throw new \Exception("Class $class does not exist or does not implement FormsInterface");
        }

        $schema = $class::formSchema($schema);

        return $schema;
    }
}
