<?php

namespace MbeGroup\Job\Filament;

use Filament\Contracts\Plugin;
use Filament\Panel;
use MbeGroup\Job\Filament\Resources\JobOfferResource;
use Filament\Facades\Filament;
use Filament\Navigation\NavigationGroup;

class JobPlugin implements Plugin
{
    public function getId(): string { return 'job'; }

    public function register(Panel $panel): void
    {
        $panel->resources([
            JobOfferResource::class,
        ]);
    }

    public function boot(Panel $panel): void
    {
        Filament::serving(function () {
            Filament::registerNavigationGroups([
                NavigationGroup::make()
                     ->label(__('job::filament.navigation.group.label'))
                     ->icon('heroicon-s-briefcase'),
            ]);
        });
    }
}
