<?php

namespace MbeGroup\Job\Filament\Resources;

use MbeGroup\Job\Models\JobOffer;

use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Tables;
use Filament\Tables\Table;
use MbeGroup\Product\Filament\Resources\ProductResource\Pages\ListProducts;
use MbeGroup\Product\Filament\Resources\ProductResource\Pages\CreateProduct;
use MbeGroup\Product\Filament\Resources\ProductResource\Pages\EditProduct;
use Filament\Actions;
use Filament\Forms;
use App\ValueObject\Status;

class JobOfferResource extends Resource
{
    protected static ?string $model = JobOffer::class;

    public static function getNavigationGroup(): string
    {
        return __('job::filament.navigation.group.label');
    }

    public static function getNavigationLabel(): string
    {
        return __('job::filament.resources.job_offer.navigation_label');
    }

    public static function getModelLabel(): string
    {
        return __('job::filament.resources.job_offer.model_label');
    }

    public static function getPluralModelLabel(): string
    {
        return __('job::filament.resources.job_offer.plural_model_label');
    }

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label(__('job::filament.resources.job_offer.form.fields.name'))
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('ID')
                    ->sortable(),
                Tables\Columns\TextColumn::make('name')
                    ->label(__('job::filament.resources.job_offer.table.columns.name'))
                    ->searchable()
            ])
            ->filters([
                //
            ])
            ->recordActions([
                Actions\EditAction::make(),
                Actions\DeleteAction::make(),
            ])
            ->toolbarActions([
                Actions\BulkActionGroup::make([
                    Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->description('Version: ' . \Composer\InstalledVersions::getVersion('mbegroup/job'));
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListProducts::route('/'),
            'create' => CreateProduct::route('/create'),
            'edit' => EditProduct::route('/{record}/edit'),
        ];
    }
}
