<?php

namespace MbeGroup\Job\Filament\Resources\JobOfferResource\Pages;

use MbeGroup\Job\Filament\Resources\JobOfferResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateJobOffer extends CreateRecord
{
    protected static string $resource = JobOfferResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.resources.users.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }
}
