<?php

namespace MbeGroup\Job\Services;

use MbeGroup\Job\Contracts\JobOfferContentServiceInterface;
use MbeGroup\Employer\Models\Employer;
use Tiptap\Editor;

class JobOfferContentService implements JobOfferContentServiceInterface
{
    public function generateContent(array $data): string
    {
        $employerId = $data['employer_id'];
        $tempalteName = $data['job_offer_template_name'];
        if (!$employerId || !$tempalteName) {
            return '';
        }
        $employerTemplates = Employer::find($employerId)?->job_offer_template ?? null;
        $template = $employerTemplates ? collect($employerTemplates)->firstWhere('job_offer_template_name', $tempalteName)['job_offer_template_html'] : null;

        if (!$template) {
            return '';
        }

        $contentVariables = $data['template_variables'] ?? [];
        $variables = array_merge($data, $contentVariables);
        $content = $template;
        preg_match_all('/\{([a-zA-Z0-9_]+)\}/', $template, $matches);

        if (!empty($matches[1])) {
            foreach ($matches[1] as $variableName) {
                $value = null;
                $value = match($variableName) {
                    'city' => isset($data['locations']) ? implode(', ', array_map(fn($loc) => $loc['location_name'] ?? '', $data['locations'])) : '',
                    'dir' => $employerId ? asset('storage/employers/' . $employerId) : '',
                    default => $variables[$variableName] ?? null,
                };

                if (is_array($value)) {
                   $value = (new Editor())->setContent($value)->getHTML();
                }

                if ($value !== null && (is_string($value) || is_numeric($value))) {
                    $content = str_replace('{' . $variableName . '}', $value, $content);
                }
            }
        }

        return $content;
    }
}
