<?php

namespace MbeGroup\Job\Console\Commands;

use Illuminate\Console\Command;
use MbeGroup\Job\Models\Import;
use MbeGroup\Job\Jobs\ProcessImportJob;
use App\ValueObject\Status;
use MbeGroup\Job\Contracts\JobOfferArchiveServiceInterface;

class RunImportCommand extends Command
{
    protected $signature = 'job-offers:run {import : Import provider_type or name}';
    protected $description = 'Manually run a specific import';

    public function handle(): int
    {
        $identifier = $this->argument('import');

        $import = Import::where('provider_type', $identifier)
            ->orWhere('name', $identifier)
            ->first();

        if (!$import) {
            $this->error("Import '{$identifier}' not found.");
            return self::FAILURE;
        }

        if (!$import->status->isActive()) {
            $this->warn("Warning: Import '{$import->name}' is not active.");

            if (!$this->confirm('Do you want to run it anyway?')) {
                return self::FAILURE;
            }
        }

        ProcessImportJob::dispatch($import->_id, app(JobOfferArchiveServiceInterface::class));

        $this->info("✓ Import '{$import->name}' dispatched to queue.");
        $this->line("Monitor progress with: php artisan queue:work");

        return self::SUCCESS;
    }
}
