<?php
namespace MbeGroup\Job\Providers;

use Illuminate\Support\ServiceProvider;
use MbeGroup\Job\Services;
use MbeGroup\Job\Contracts;
use MbeGroup\Job\Console\Commands;

final class JobServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->bind(
            Contracts\JobOfferContentServiceInterface::class,
            Services\JobOfferContentService::class
        );
        $this->app->bind(
            Contracts\JobOffersSearchServiceInterface::class,
            Services\JobOffersSearchService::class
        );
        $this->app->bind(
            Contracts\JobOffersSalaryServiceInterface::class,
            Services\JobOffersSalaryService::class
        );

        $this->app->bind(
            Contracts\JobOfferArchiveServiceInterface::class,
            Services\JobOfferArchiveService::class
        );

        $this->app->bind(
            Contracts\ScraperJobOfferServiceInterface::class,
            Services\ScraperJobOfferService::class
        );

        $this->app->bind(
            Contracts\JobOfferCopyServiceInterface::class,
            Services\JobOfferCopyService::class
        );

        $this->app->bind(
            Contracts\ConnectJobOffersServiceInterface::class,
            Services\ConnectJobOffersService::class
        );

        $this->app->bind(
            Contracts\ApplicationServiceInterface::class,
            Services\ApplicationService::class
        );
    }

    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');
        $this->loadRoutesFrom(__DIR__ . '/../../routes/console.php');
        $this->loadTranslationsFrom(__DIR__ . '/../../lang', 'job');
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'job');
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\JobOffersReindex::class,
                Commands\JobOffersExpire::class,
                Commands\JobOffersArchive::class,
                Commands\CheckImportsCommand::class,
                Commands\RunImportCommand::class,
            ]);
        }
    }
}
