<?php

use Illuminate\Support\Facades\Route;
use MbeGroup\Job\Controllers\Api\V1;

Route::prefix('api')->group(function () {
    Route::prefix('v1')->group(function () {
        Route::middleware('auth:sanctum')->group(function () {
            Route::prefix('job-offers')->group(function () {
                Route::post('apply', [V1\ApplicationController::class, 'store']);
                Route::get('apply', [V1\ApplicationController::class, 'index']);
                Route::get('search', [V1\JobOfferController::class, 'search']);
                Route::get('{id}', [V1\JobOfferController::class, 'show']);
            });
        });
    });
});
