<?php

use Illuminate\Support\Facades\Route;
use MbeGroup\Job\Controllers\Api\V1;

Route::prefix('api')->group(function () {
    Route::prefix('v1')->group(function () {
        Route::middleware('auth:sanctum')->group(function () {
            Route::prefix('job-offers')->group(function () {
                Route::get('search', [V1\JobOfferController::class, 'search']);
                Route::prefix('apply')->group(function () {
                    Route::post('/', [V1\ApplicationController::class, 'store']);
                    Route::get('/', [V1\ApplicationController::class, 'index']);
                });
                Route::prefix('favorites')->group(function () {
                    Route::post('/', [V1\FavoriteController::class, 'store']);
                    Route::get('/', [V1\FavoriteController::class, 'index']);
                    Route::delete('/{id}', [V1\FavoriteController::class, 'destroy']);
                });
                Route::get('{id}', [V1\JobOfferController::class, 'show']);
            });
        });
    });
});
