<?php

namespace MbeGroup\Job\Services;

use MbeGroup\Job\Models\JobOffer;
use MbeGroup\Job\Contracts\JobOfferCopyServiceInterface;
use App\ValueObject\Status;
use Illuminate\Support\Facades\DB;

class JobOfferCopyService implements JobOfferCopyServiceInterface
{
    public function copyOffer(JobOffer $jobOffer): JobOffer
    {
        return DB::transaction(function () use ($jobOffer) {
            $attributes = $jobOffer->getAttributes();
            if ($jobOffer->shouldBeSearchable()) {
                $jobOffer->unsearchable();
            }

            unset($attributes['id']);
            unset($attributes['product_statistics']);

            $attributes['status'] = Status::DRAFT;
            $attributes['created_at'] = now();
            $attributes['updated_at'] = now();

            $copiedOffer = new JobOffer();
            $copiedOffer->setRawAttributes($attributes);
            $copiedOffer->save();

            return $copiedOffer;
        });
    }
}
