<?php

namespace MbeGroup\Job\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface JobOffersSearchServiceInterface
{
    /**
     * Search for job offers based on provided filters.
     *
     * @param array $filters Associative array of filters (e.g., 'q', 'industry_ids', 'specialization_ids', 'employer_ids').
     * @param int $perPage Number of results per page.
     * @param int $page Current page number.
     * @return LengthAwarePaginator Paginated list of job offers matching the search criteria.
     */
    public function search(array $filters, int $perPage, int $page): LengthAwarePaginator;
}
