<?php

namespace MbeGroup\Job\Filament\Resources\ArchiveJobOfferResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use MbeGroup\Job\Filament\Resources\ArchiveJobOfferResource;
use MbeGroup\Job\Contracts\JobOfferContentServiceInterface;
use MbeGroup\Job\Contracts\JobOffersSalaryServiceInterface;

class EditArchiveJobOffer extends EditRecord
{
    protected static string $resource = ArchiveJobOfferResource::class;
    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function getFormActions(): array
    {
        return [
            $this->getSaveFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('product::filament.resources.product.form.description.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->save();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            $this->getCancelFormAction(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $user = auth()->user();
        $data['updated_by'] = $user ? $user->name . ' '. $user->surname : 'system';
        $data['template'] = app(JobOfferContentServiceInterface::class)->generateContent($data);
        $data['salary_for_search'] = app(JobOffersSalaryServiceInterface::class)->getSearchSalaryRange($data['salary'] ?? []);

        return $data;
    }

    protected function afterSave(): void
    {
        $this->syncProductStatistics();
    }

    protected function syncProductStatistics(): void
    {
        $record = $this->getRecord();

        if ($record->wasChanged('product_statistics')) {
            try {
                $oldProductStatisticsId = $record->getPrevious()['product_statistics'];
                $newProductStatisticsId = $record->product_statistics;

                if ($newProductStatisticsId) {
                    $newProductStatistics = \MbeGroup\Product\Models\ProductStatistics::find($newProductStatisticsId);
                    if ($newProductStatistics && $newProductStatistics->quantity > 0) {
                        $newProductStatistics->decrement('quantity');
                    }
                }
            } catch (\Exception $e) {
                \Illuminate\Support\Facades\Log::error('Error syncing product statistics: ' . $e->getMessage());
            }
        }
    }
}
