<?php

namespace MbeGroup\Job\Console\Commands;

use Illuminate\Console\Command;
use MbeGroup\Job\Models\JobOffer;
use App\ValueObject\Status;
use Illuminate\Support\Facades\Log;

class JobOffersExpire extends Command
{
    protected $signature = 'job-offers:expire';

    protected $description = 'Wygasza przeterminowane oferty pracy';

    public function handle()
    {
        try {
            $count = 0;

            JobOffer::where('status', Status::ACTIVE)
                ->whereNotNull('expiration_date')
                ->where('expiration_date', '<', now())
                ->chunkById(100, function ($offers) use (&$count) {
                    foreach ($offers as $offer) {
                        $offer->status = Status::EXPIRED;
                        $offer->save();
                        $count++;
                    }
                });

            if ($count > 0) {
                Log::info("Wygaszono {$count} przeterminowanych ofert pracy");
                $this->info("✓ Wygaszono {$count} ofert pracy");
            } else {
                $this->info("Brak ofert do wygaszenia");
            }

            return 0;

        } catch (\Exception $e) {
            Log::error('Błąd podczas wygaszania ofert pracy', [
                'error' => $e->getMessage()
            ]);

            $this->error("Błąd: {$e->getMessage()}");
            return 1;
        }
    }
}
