<?php

namespace MbeGroup\Job\Contracts;

use Illuminate\Support\Collection;

interface ScraperJobOfferServiceInterface
{
    /**
     * Fetches available providers list
     *
     * @param string $provider
     *
     * @return Collection
     */
    public function getAvailableProviderList(string $provider): Collection;

    /**
     * Fetches job offer count
     *
     * @param string $provider
     *
     * @return Collection
     */
    public function getJobOfferCount(string $provider): Collection;

    /**
     * Fetches job offer list
     *
     * @param string $provider
     * @param int $offset
     * @param int $limit
     *
     * @return Collection
     */
    public function getJobOfferList(string $provider, int $offset, int $limit = 10): Collection;

}
