<?php

namespace MbeGroup\Job\Filament\Resources\JobOfferResource\Pages;

use MbeGroup\Job\Filament\Resources\JobOfferResource;
use Filament\Resources\Pages\CreateRecord;
use Filament\Actions;

class CreateJobOffer extends CreateRecord
{
    protected static string $resource = JobOfferResource::class;

    protected function getFormActions(): array
    {
        return [
            $this->getCreateFormAction(),
            Actions\Action::make('saveAndBack')
                ->label(__('filament.general.saveAndBack'))
                ->color('gray')
                ->action(function () {
                    $this->create();
                    $this->redirect($this->getResource()::getUrl('index'));
                })
                ->keyBindings(['mod+shift+s']),
            ...(static::canCreateAnother() ? [$this->getCreateAnotherFormAction()] : []),
            $this->getCancelFormAction(),
        ];
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $user = auth()->user();
        $data['created_by'] = $user ? $user->name . ' '. $user->surname : 'system';
        $data['updated_by'] = null;
        return $data;
    }

    protected function afterCreate(): void
    {
        $this->syncProductStatistics();
    }

    protected function syncProductStatistics(): void
    {
        $record = $this->getRecord();
        $productStatisticsId = $this->data['product_statistics'] ?? null;

        if ($productStatisticsId) {
            try {
                $productStatistics = \MbeGroup\Product\Models\ProductStatistics::find($productStatisticsId);
                $employer = $record->employer;

                if ($productStatistics && $productStatistics->quantity > 0 && $employer) {
                    // Dekrementuj w ProductStatistics
                    $productStatistics->decrement('quantity');

                    // Dekrementuj w embedded products
                    $products = $employer->products;
                    $index = array_search($productStatistics->employer_item_id, array_column($products, 'item_id'));

                    if ($index !== false) {
                        $products[$index]['quantity'] -= 1;

                        if ($products[$index]['quantity'] <= 0) {
                            unset($products[$index]);
                            $products = array_values($products);
                        }

                        $employer->products = $products;
                        $employer->save();
                    }
                }
            } catch (\Exception $e) {
                \Illuminate\Support\Facades\Log::error('Error syncing product statistics: ' . $e->getMessage());
            }
        }
    }
}
