<?php

namespace MbeGroup\Job\Filament\Resources\ApplicationResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;
use MbeGroup\Job\Filament\Resources\ApplicationResource;
use Filament\Support\Enums\FontWeight;
use MbeGroup\Job\Jobs\ProcessImportJob;
use Filament\Notifications\Notification;
use Filament\Schemas\Schema;
use Filament\Schemas\Components\Section;
use Filament\Schemas\Components\Grid;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\RepeatableEntry;
use Filament\Infolists\Components\KeyValueEntry;
use Filament\Support\Enums\TextSize;
use App\ValueObject\Status;
use Dom\Text;
use MbeGroup\Job\Contracts\JobOfferArchiveServiceInterface;
use Filament\Infolists\Components\Actions\Action;
use Filament\Infolists\Components\ViewEntry;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Support\HtmlString;

class ViewApplication extends ViewRecord
{
    protected static string $resource = ApplicationResource::class;

    public function infolist(Schema $schema): Schema
    {
        return $schema
            ->schema([
                Section::make('Informacje o kandydacie')
                    ->schema([
                        Grid::make(3)
                            ->schema([
                                TextEntry::make('candidate_full_name')
                                    ->label('Imię i nazwisko')
                                    ->weight(FontWeight::Bold)
                                    ->size(TextSize::Large)
                                    ->icon('heroicon-o-user')
                                    ->columnSpan(2),
                                IconEntry::make('user_id')
                                    ->label('Status konta')
                                    ->state(fn ($record) => !is_null($record->user_id))
                                    ->boolean()
                                    ->trueIcon('heroicon-o-check-circle')
                                    ->falseIcon('heroicon-o-x-circle')
                                    ->trueColor('success')
                                    ->falseColor('warning')
                                    ->tooltip(fn ($record) => $record->isGuest() ? 'Aplikacja gościa' : 'Zarejestrowany użytkownik'),
                            ]),
                        Grid::make(2)
                            ->schema([
                                TextEntry::make('candidate_email')
                                    ->label('Email')
                                    ->icon('heroicon-o-envelope')
                                    ->copyable()
                                    ->url(fn ($record) => "mailto:{$record->candidate_email}"),
                                TextEntry::make('candidate_phone')
                                    ->label('Telefon')
                                    ->icon('heroicon-o-phone')
                                    ->copyable()
                                    ->placeholder('Nie podano')
                                    ->url(fn ($record) => $record->candidate_phone ? "tel:{$record->candidate_phone}" : null),
                            ]),
                        TextEntry::make('user.email')
                            ->label('Email użytkownika')
                            ->icon('heroicon-o-user-circle')
                            ->visible(fn ($record) => !$record->isGuest())
                            ->placeholder('Brak powiązanego użytkownika'),
                    ])
                    ->icon('heroicon-o-identification'),

                Section::make('Szczegóły aplikacji')
                    ->schema([
                        Grid::make(2)
                            ->schema([
                                TextEntry::make('jobOffer.title')
                                    ->label('Oferta pracy')
                                    ->weight(FontWeight::Bold)
                                    ->icon('heroicon-o-briefcase')
                                    ->placeholder('Brak danych'),
                                TextEntry::make('jobOffer.id')
                                    ->label('ID oferty')
                                    ->copyable()
                                    ->icon('heroicon-o-hashtag'),
                            ]),
                        Grid::make(2)
                            ->schema([
                                TextEntry::make('employer.name')
                                    ->label('Pracodawca')
                                    ->icon('heroicon-o-building-office')
                                    ->placeholder('Brak danych'),
                                TextEntry::make('type.name')
                                    ->label('Typ aplikacji')
                                    ->badge()
                                    ->placeholder('Nie określono'),
                            ]),
                        TextEntry::make('created_at')
                            ->label('Data zgłoszenia')
                            ->dateTime('d.m.Y H:i')
                            ->icon('heroicon-o-calendar'),
                    ])
                    ->icon('heroicon-o-document-text'),

                Section::make('CV')
                    ->schema([
                        TextEntry::make('cv_file.original_name')
                            ->label('Plik CV')
                            ->icon('heroicon-o-document-text')
                            ->default('Nie załączono CV')
                            ->url(fn ($record) => isset($record->cv_file['path']) ? \Storage::url($record->cv_file['path']) : null)
                            ->openUrlInNewTab()
                            ->color(fn ($record) => !empty($record->cv_file) ? 'primary' : 'gray')
                            ->badge(),
                        Grid::make(3)
                            ->schema([
                                TextEntry::make('cv_file.size')
                                    ->label('Rozmiar')
                                    ->formatStateUsing(fn ($state) => $state ? number_format($state / 1024, 2) . ' KB' : '-')
                                    ->icon('heroicon-o-document'),
                                TextEntry::make('cv_file.mime_type')
                                    ->label('Typ pliku')
                                    ->badge()
                                    ->color('gray'),
                                TextEntry::make('cv_file.uploaded_at')
                                    ->label('Przesłano')
                                    ->dateTime('d.m.Y H:i')
                                    ->icon('heroicon-o-clock'),
                            ])
                            ->visible(fn ($record) => !empty($record->cv_file)),
                    ])
                    ->icon('heroicon-o-document-text')
                    ->collapsible(),

                Section::make('Informacje systemowe')
                    ->schema([
                        Grid::make(3)
                            ->schema([
                                TextEntry::make('id')
                                    ->label('ID aplikacji')
                                    ->copyable()
                                    ->icon('heroicon-o-hashtag'),
                                TextEntry::make('created_at')
                                    ->label('Utworzono')
                                    ->dateTime('d.m.Y H:i:s')
                                    ->icon('heroicon-o-clock'),
                                TextEntry::make('updated_at')
                                    ->label('Zaktualizowano')
                                    ->dateTime('d.m.Y H:i:s')
                                    ->icon('heroicon-o-arrow-path'),
                            ]),
                    ])
                    ->icon('heroicon-o-information-circle')
                    ->collapsed(true)
                    ->collapsible(),
            ]);
    }
}
