<?php

namespace MbeGroup\Job\Requests;

use Illuminate\Foundation\Http\FormRequest;
use MbeGroup\Job\Models\JobOffer;
use MbeGroup\Job\Models\Favorite;

class FavoriteRequest extends FormRequest
{
    protected ?JobOffer $jobOffer = null;

      /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

      /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        return [
            'job_offer_id' => [
                'required',
                'string',
                function ($attribute, $value, $fail) {
                    $this->jobOffer = JobOffer::find($value);
                    if (!$this->jobOffer) {
                        $fail('Wybrana oferta pracy nie istnieje.');
                        return;
                    }

                    $user = auth()->user();
                    if ($user && Favorite::where('user_id', $user->id)
                                        ->where('job_offer_id', $value)
                                        ->exists()) {
                        $fail('Ta oferta jest już w Twoich ulubionych.');
                    }
                },
            ]
        ];
    }

    public function messages()
    {
        return [
            'job_offer_id.required' => 'Pole oferta pracy jest wymagane.',
            'job_offer_id.string'   => 'Pole oferta pracy musi być ciągiem znaków.',
        ];
    }

    public function getJobOffer(): JobOffer
    {
        return $this->jobOffer;
    }
}
