<?php

namespace MbeGroup\Job\Services;

use MbeGroup\Job\Contracts\JobOfferContentServiceInterface;
use MbeGroup\Employer\Models\Employer;
use Tiptap\Editor;

class JobOfferContentService implements JobOfferContentServiceInterface
{
    public function getTemplateByEmployerIdAndTemplateName(string $employerId, string $templateName): ?array
    {
        $employer = Employer::find($employerId);
        if (!$employer || !isset($employer->job_offer_template)) {
            return null;
        }
        $templates = $employer->job_offer_template;
        if (!is_array($templates)) {
            return null;
        }
        $templateElement = collect($templates)->firstWhere('job_offer_template_name', $templateName);
        return $templateElement ?? null;
    }

    public function generateContent(array $data): string
    {
        $employerId   = $data['employer_id'];
        $tempalteName = $data['job_offer_template_name'];
        if (!$employerId || !$tempalteName) {
            return '';
        }
        $templateElement = $this->getTemplateByEmployerIdAndTemplateName($employerId, $tempalteName);
        $template        = $templateElement['job_offer_template_html'] ?? null;

        if (!$template) {
            return '';
        }

        $contentVariables = $data['template_variables'] ?? [];

        $variables = array_merge($data, $contentVariables);

        $content = $template;
        preg_match_all('/\{([a-zA-Z0-9_\-\.]+)\}/', $template, $matches);

        if (!empty($matches[1])) {
            foreach ($matches[1] as $variableName) {
                $value = null;
                $value = match($variableName) {
                    'city'  => isset($data['locations']) ? implode(', ', array_map(fn($loc) => $loc['location_name'] ?? '', $data['locations'])) : '',
                    'dir'   => $employerId ? asset('storage/employers/' . $employerId) : '',
                    default => $variables[$variableName] ?? null,
                };

                if (is_array($value) && !empty($value)) {
                    $value = match($variableName) {
                        'benefits'           => $this->generateBenefitsHtml($value, $variables['dir'] ?? ''),
                        'recruitment-stages' => $this->generateRecruitmentStagesHtml($value),
                        default              => (new Editor())->setContent($value)->getHTML(),
                    };
                }

                if ($value !== null && (is_string($value) || is_numeric($value))) {
                    $content = str_replace('{' . $variableName . '}', $value, $content);
                }
            }
        }

        return $content;
    }

    private function generateRecruitmentStagesHtml(array $data): string
    {
        return view('job::partials.recruitment-stages', [
            'stageCount'     => $data['stage_count'] ?? '',
            'stageDuration'  => $data['stage_duration'] ?? '',
            'stageStartDate' => $data['stage_start_date'] ?? '',
            'stages'         => array_values($data['stage'] ?? []),
        ])->render();
    }

    private function generateBenefitsHtml(array $benefits, string $dir): string
    {
        return view('job::partials.benefits', [
            'benefits' => $benefits,
        ])->render();
    }
}
