<?php

namespace MbeGroup\Job\Console\Commands;

use Illuminate\Console\Command;
use MbeGroup\Job\Models\Import;
use MbeGroup\Job\Jobs\ProcessImportJob;
use MbeGroup\Job\Contracts\JobOfferArchiveServiceInterface;

class CheckImportsCommand extends Command
{
    protected $signature = 'job-offers:check-imports';
    protected $description = 'Check and dispatch imports that should run';

    public function handle(): int
    {
        $imports = Import::shouldRun()->get();

        if ($imports->isEmpty()) {
            $this->info('No imports to run at this time.');
            return self::SUCCESS;
        }

        $this->info("Found {$imports->count()} import(s) to process.");

        foreach ($imports as $import) {
            ProcessImportJob::dispatch($import->_id, app(JobOfferArchiveServiceInterface::class));
            $this->line("✓ Dispatched import: {$import->name} (ID: {$import->_id})");
        }

        return self::SUCCESS;
    }
}
