<?php

namespace MbeGroup\Job\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class JobOfferResource extends JsonResource
{
      /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $resource = [
            'id'       => $this->public_id,
            'employer' => $this->employer ? [
                'id'       => $this->employer->id,
                'name'     => $this->employer->name,
                'slug'     => $this->employer->slug,
                'logo_url' => $this->employer->getLogoUrlAttribute(),
            ] : null,
            'title'                                    => $this->title,
            'slug'                                     => $this->slug,
            'reference_number'                         => $this->reference_number,
            'status'                                   => $this->status,
            'locations'                                => $this->locations,
            'industries'                               => $this->getIndustries(),
            'specializations'                          => $this->getSpecializations(),
            'position'                                 => $this->getPosition(),
            'position_level'                           => $this->getPositionLevel(),
            'is_for_technicians'                       => $this->is_for_technicians,
            'operating_modes'                          => $this->getOperatingModes(),
            'is_remote_recruitment'                    => $this->is_remote_recruitment,
            'employment_types'                         => $this->getEmploymentTypes(),
            'hourly_rate'                              => $this->getHourlyRate(),
            'preferred_studies'                        => $this->getPreferredStudies(),
            'workplace_types'                          => $this->getWorkplaceTypes(),
            'work_system'                              => $this->getWorkSystem(),
            'delegations'                              => $this->getDelegations(),
            'contract_duration'                        => $this->getContractDuration(),
            'salary_structures'                        => $this->getSalaryStructures(),
            'has_team_management'                      => $this->has_team_management,
            'has_driving_license'                      => $this->has_driving_license,
            'no_experience'                            => $this->no_experience,
            'has_company_car'                          => $this->has_company_car,
            'competences'                              => $this->getPreparedCompetences(),
            'nice_to_have_languages'                   => $this->getNiceToHaveLanguages(),
            'nice_to_have_technologies_and_tools'      => $this->getNiceToHaveTechnologiesAndTools(),
            'nice_to_have_skills_and_methodologies'    => $this->getNiceToHaveSkillsAndMethodologies(),
            'nice_to_have_licenses_and_qualifications' => $this->getNiceToHaveLicensesAndQualifications(),
            'application_method'                       => $this->application_method,
            'is_top_offer'                             => $this->is_top_offer,
            'salary'                                   => $this->getPreparedSalary(),
            'template_benefits'                        => $this->template_benefits,
            'template_recruitment_stages'              => $this->template_recruitment_stages,
            'publication_date'                         => $this->publication_date,
            'expiration_date'                          => $this->expiration_date,
            'template'                                 => $this->template,
            'created_at'                               => $this->created_at,
            'updated_at'                               => $this->updated_at,
        ];
        return $resource;
    }
}
