<?php

namespace MbeGroup\Job\Services;

use MbeGroup\Job\Contracts\FavoriteServiceInterface;
use MbeGroup\Job\Models\Favorite;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

class FavoriteService implements FavoriteServiceInterface
{
    public function getFavoritesForUser($user, int $page = 1, int $perPage = 15): LengthAwarePaginator
    {
        return Favorite::where('user_id', $user->id)
            ->with('jobOffer')
            ->orderBy('created_at', 'desc')
            ->paginate($perPage, ['*'], 'page', $page);
    }
}
