<?php

namespace MbeGroup\Job\Contracts;
use MbeGroup\Job\Models\JobOffer;;
use MbeGroup\Job\Models\ArchivedJobOffer;

interface JobOfferArchiveServiceInterface
{
    /**
     * Archive a single job offer
     *
     * @param JobOffer $jobOffer
     * @param string|null $reason
     *
     * @return ArchivedJobOffer
     */
    public function archiveOffer(JobOffer $jobOffer, ?string $reason = null): ArchivedJobOffer;

    /**
     * Archive multiple job offers
     *
     * @param array $offerIds
     * @param string|null $reason
     *
     * @return array<ArchivedJobOffer>
     */
    public function archiveOffers(array $offerIds, ?string $reason = null): array;

    /**
     * Restore archived offer back to active offers
     *
     * @param ArchivedJobOffer $archivedOffer
     *
     * @return JobOffer
     */
    public function restoreOffer(ArchivedJobOffer $archivedOffer): JobOffer;
}
