<?php

namespace MbeGroup\Job\Contracts;

interface JobOfferContentServiceInterface
{
    /**
     * Pobiera szablon oferty pracy na podstawie ID pracodawcy i nazwy szablonu.
     *
     * @param string $employerId
     * @param string $templateName
     * @return array|null
     */
    public function getTemplateByEmployerIdAndTemplateName(string $employerId, string $templateName): ?array;

    /**
     * Generuje treść oferty pracy na podstawie danych i szablonu.
     *
     * @param array $data
     * @return string
     */
    public function generateContent(array $data): string;
}
