<?php

namespace MbeGroup\Job\Models;

use MongoDB\Laravel\Eloquent\Model;
use MbeGroup\Employer\Models\Employer;
use App\Models\User;
use App\Models\Dictionary;

class Application extends Model
{
    protected $connection = 'mongodb';
    protected $collection = 'applications';

    protected $fillable = [
        'job_offer_id',
        'user_id',
        'employer_id',
        'type_id',
        'cv_file',
        'candidate_first_name',
        'candidate_last_name',
        'candidate_email',
        'candidate_phone',
        'cv_file',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function type()
    {
        return $this->belongsTo(Dictionary::class, 'type_id');
    }

    public function jobOffer()
    {
        return $this->belongsTo(JobOffer::class, 'job_offer_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function employer()
    {
        return $this->belongsTo(Employer::class, 'employer_id');
    }

    public function getCandidateFullNameAttribute()
    {
        return "{$this->candidate_first_name} {$this->candidate_last_name}";
    }

    public function isGuest()
    {
        return is_null($this->user_id);
    }

    public function scopeByCandidate($query, $email)
    {
        return $query->where('candidate_email', $email);
    }

    public function scopeByEmployer($query, $employerId)
    {
        return $query->where('employer_id', $employerId);
    }

    public function scopeGuests($query)
    {
        return $query->whereNull('user_id');
    }

    public function scopeRegistered($query)
    {
        return $query->whereNotNull('user_id');
    }
}
