<?php

namespace MbeGroup\Job\Services;

use MbeGroup\Job\Contracts\JobOffersSalaryServiceInterface;
use App\Helpers\DictionaryHelper;
use App\Models\ExchangeRate;

class JobOffersSalaryService implements JobOffersSalaryServiceInterface
{
    const HOUR_TO_MONTH_FACTOR = 168;

    public function getSearchSalaryRange(array $salaryList): array
    {
        $salaryValuesInPLN = [];
        $minSalary = null;
        $maxSalary = null;

        $salaryCurrencies = DictionaryHelper::getNamesByType('currency');
        $hourlySalaryTypeId = DictionaryHelper::getIdBySlug('hourly');

        foreach ($salaryList as $salary) {
            if (!isset($salary['salary_from'], $salary['salary_to'], $salary['salary_currency'], $salary['salary_type'])) {
                continue;
            }

            $factor = $salary['salary_type'] === $hourlySalaryTypeId
                ? self::HOUR_TO_MONTH_FACTOR
                : 1;

            $currency = $salaryCurrencies[$salary['salary_currency']];

            if ($currency === 'PLN') {
                $salaryFromInPLN = intval($salary['salary_from'] * $factor);
                $salaryToInPLN = intval($salary['salary_to'] * $factor);
            } else {
                $exchangeRate = ExchangeRate::getLatestRate($currency);

                if ($exchangeRate) {
                    $salaryFromInPLN = intval($salary['salary_from'] * $factor * $exchangeRate);
                    $salaryToInPLN = intval($salary['salary_to'] * $factor * $exchangeRate);
                } else {
                    $salaryFromInPLN = null;
                    $salaryToInPLN = null;
                }
            }

            $salaryValuesInPLN[] = ['from' => $salaryFromInPLN, 'to' => $salaryToInPLN];

            if ($salaryFromInPLN !== null) {
                $minSalary = $minSalary === null ? $salaryFromInPLN : min($minSalary, $salaryFromInPLN);
            }

            if ($salaryToInPLN !== null) {
                $maxSalary = $maxSalary === null ? $salaryToInPLN : max($maxSalary, $salaryToInPLN);
            }
        }

        return [
            'from' => $minSalary,
            'to' => $maxSalary,
        ];
    }
}
