<?php

namespace MbeGroup\Job\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface FavoriteServiceInterface
{
    /**
     * Pobiera listę ulubionych dla danego użytkownika
     *
     * @param mixed $user Obiekt użytkownika, dla którego mają być pobrane ulubione
     * @return LengthAwarePaginator Zwraca paginowaną listę ulubionych
     */
    public function getFavoritesForUser($user, int $page = 1, int $perPage = 15): LengthAwarePaginator;
}
