<?php

namespace MbeGroup\Job\Services;

use Illuminate\Support\Collection;
use MbeGroup\Job\Contracts\ScraperJobOfferServiceInterface;
use GuzzleHttp;
use Illuminate\Support\Facades\Log;

class ScraperJobOfferService implements ScraperJobOfferServiceInterface
{
    const OFFSET = 0;
    const LIMIT = 10;

    private $scraperApiUrl;
    private $httpClient;

    public function __construct()
    {
        $this->scraperApiUrl = env('SCRAPER_API_URL');
        $this->httpClient = new GuzzleHttp\Client();
    }

    private function makeRequest(string $endpoint, array $params = []): Collection
    {
        $request = $this->httpClient->get($this->scraperApiUrl . $endpoint, [
            'auth' => [env('SCRAPER_BASIC_AUTH_USER'), env('SCRAPER_BASIC_AUTH_PASSWORD')],
            'query' => $params
        ]);
        $responseBody = $request->getBody()->getContents();
        Log::info("Response status: " . $request->getStatusCode());
        return collect(json_decode($responseBody, true));
    }

    public function getAvailableProviderList(string $provider): Collection
    {
        $result = $this->makeRequest('/providers');

        return $result;
    }

    public function getJobOfferCount(string $provider): Collection
    {
        $result = $this->makeRequest('/scrape/'. $provider . '/count');

        return $result;
    }

    public function getJobOfferList(string $provider, int $offset = self::OFFSET, int $limit = self::LIMIT): Collection
    {
        $result = $this->makeRequest('/scrape/'. $provider, [
            'limit' => $limit,
            'offset' => $offset
        ]);

        return $result;
    }
}
