<?php

namespace MbeGroup\Job\Observers;

use MbeGroup\Job\Models\JobOffer;

class JobOfferObserver
{
    public function deleting(JobOffer $jobOffer): void
    {
        $this->restoreSlotProductStatistics($jobOffer);
    }

    private function restoreSlotProductStatistics(JobOffer $jobOffer): void
    {
        try {
            $productStatisticsId = $jobOffer->product_statistics;

            if (!$productStatisticsId) {
                return;
            }

            $productStatistics = \MbeGroup\Product\Models\ProductStatistics::find($productStatisticsId);
            $employer          = $jobOffer->employer;

            if (!$productStatistics || !$employer) {
                return;
            }

            $products = $employer->products;

            if (!$this->isSlotProduct($productStatistics, $products)) {
                return;
            }

            $productStatistics->increment('quantity');

            $index = array_search($productStatistics->employer_item_id, array_column($products, 'item_id'));

            if ($index !== false) {
                $products[$index]['quantity'] += 1;
                $employer->products = $products;
                $employer->save();
            }
        } catch (\Throwable $t) {
            \Illuminate\Support\Facades\Log::error('Error restoring slot product statistics on delete: ' . $t->getMessage());
        }
    }

    private function isSlotProduct($productStatistics, $products): bool
    {
        $selectedProduct = collect($products)->firstWhere('product_id', $productStatistics->product_id);

        return $selectedProduct && isset($selectedProduct['is_slot']) && $selectedProduct['is_slot'];
    }
}
