<?php

namespace MbeGroup\Job\Services;

use MbeGroup\Job\Contracts\ConnectJobOffersServiceInterface;
use MbeGroup\Job\Models\JobOffer;
use Ramsey\Uuid\Uuid;

class ConnectJobOffersService implements ConnectJobOffersServiceInterface
{
    /**
     * Connect job offers by their IDs.
     *
     * @param array $ids
     * @return void
     */
    public function connectOffersByIds(array $ids): void
    {
        $jobOffers = JobOffer::whereIn('_id', $ids)->get();

        $connectionId = $this->generateConnectionId();

        foreach ($jobOffers as $jobOffer) {
            if ($jobOffer->isConnected()) {
                $connectionId = $jobOffer->connection_id;
            }
        }

        foreach ($jobOffers as $jobOffer) {
            $jobOffer->connect($connectionId);
        }
    }

    /**
     * Generate a unique connection ID.
     *
     * @return string
     */
    protected function generateConnectionId(): string
    {
        return (string) Uuid::uuid1();
    }
}
