<?php

namespace MbeGroup\Job\Console\Commands;

use Illuminate\Console\Command;
use MbeGroup\Job\Models\JobOffer;
use App\ValueObject\Status;
use Illuminate\Support\Facades\Log;
use MbeGroup\Job\Contracts\JobOfferArchiveServiceInterface;

class JobOffersArchive extends Command
{
    protected $signature = 'job-offers:archive';

    protected $description = 'Archiwizuje przeterminowane oferty pracy';
    public function handle()
    {
        try {
            $count = 0;

            JobOffer::where('status', Status::EXPIRED)
                ->whereNotNull('updated_at')
                ->where('updated_at', '<', now()->sub(1, 'day'))
                ->chunkById(100, function ($offers) use (&$count) {
                    foreach ($offers as $offer) {
                        app(JobOfferArchiveServiceInterface::class)->archiveOffer($offer, 'Offer expired');
                        $count++;
                    }
                });

            if ($count > 0) {
                Log::info("Zarchiwizowano {$count} przeterminowanych ofert pracy");
                $this->info("✓ Zarchiwizowano {$count} ofert pracy");
            } else {
                $this->info("Brak ofert do zarchiwizowania");
            }

            return 0;

        } catch (\Exception $e) {
            Log::error('Błąd podczas archiwizowania ofert pracy', [
                'error' => $e->getMessage()
            ]);

            $this->error("Błąd: {$e->getMessage()}");
            return 1;
        }
    }
}
